jQuery(document).ready(function($) {
    // Handle change IP form submission
    $('#licenzer-change-ip-form').on('submit', function(e) {
        e.preventDefault();
        
        var form = $(this);
        var resultDiv = $('#licenzer-change-ip-result');
        var submitBtn = form.find('button[type="submit"]');
        
        submitBtn.prop('disabled', true).text('Processing...');
        resultDiv.html('');
        
        $.ajax({
            url: licenzerAjax.ajaxurl,
            type: 'POST',
            data: {
                action: 'licenzer_change_ip',
                license_key: $('#license_key').val(),
                new_ip: $('#new_ip').val(),
                nonce: licenzerAjax.nonce
            },
            success: function(response) {
                if (response.success) {
                    resultDiv.html('<div class="licenzer-success">' + response.data.message + '</div>');
                    form[0].reset();
                } else {
                    resultDiv.html('<div class="licenzer-error">' + response.data.message + '</div>');
                }
            },
            error: function() {
                resultDiv.html('<div class="licenzer-error">An error occurred. Please try again.</div>');
            },
            complete: function() {
                submitBtn.prop('disabled', false).text('Change IP');
            }
        });
    });
});

