<?php
/**
 * Discount licenses page
 */

if (!current_user_can('manage_options')) {
    wp_die(__('You do not have sufficient permissions to access this page.'));
}

$api = new Licenzer_API();
$discount_licenses = $api->getDiscountLicenses();
$discount_list = array();

if (isset($discount_licenses['status']) && $discount_licenses['status'] == 'success') {
    $discount_list = $discount_licenses['data'] ?? array();
}

?>
<div class="wrap licenzer-discount">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <div class="notice notice-info">
        <p>
            <strong><?php _e('Discount Licenses:', 'licenzer'); ?></strong>
            <?php _e('These are licenses that were previously activated and are now available for resale at 50% discount with no setup cost.', 'licenzer'); ?>
        </p>
    </div>

    <?php if (empty($discount_list)): ?>
        <div class="notice notice-warning">
            <p><?php _e('No discount licenses available at this time.', 'licenzer'); ?></p>
        </div>
    <?php else: ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th><?php _e('License Key', 'licenzer'); ?></th>
                    <th><?php _e('Software', 'licenzer'); ?></th>
                    <th><?php _e('IP Address', 'licenzer'); ?></th>
                    <th><?php _e('Original Price', 'licenzer'); ?></th>
                    <th><?php _e('Discount Price', 'licenzer'); ?></th>
                    <th><?php _e('Expiry Date', 'licenzer'); ?></th>
                    <th><?php _e('Actions', 'licenzer'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($discount_list as $license): ?>
                <tr>
                    <td><code><?php echo esc_html($license['license_key'] ?? 'N/A'); ?></code></td>
                    <td><?php echo esc_html($license['software_name'] ?? 'N/A'); ?></td>
                    <td><?php echo esc_html($license['ip'] ?? 'N/A'); ?></td>
                    <td><del>$<?php echo number_format($license['original_price'] ?? 0, 2); ?></del></td>
                    <td><strong style="color: #46b450;">$<?php echo number_format($license['price'] ?? 0, 2); ?></strong></td>
                    <td><?php echo esc_html($license['expiry_date'] ?? 'N/A'); ?></td>
                    <td>
                        <button class="button button-small assign-license-btn" 
                                data-license-key="<?php echo esc_attr($license['license_key'] ?? ''); ?>"
                                data-ip="<?php echo esc_attr($license['ip'] ?? ''); ?>">
                            <?php _e('Assign to User', 'licenzer'); ?>
                        </button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>

