<?php
/**
 * Dashboard page
 */

if (!current_user_can('manage_options')) {
    wp_die(__('You do not have sufficient permissions to access this page.'));
}

$api = new Licenzer_API();
$licenses = $api->getLicenses();
$stats = array(
    'total' => 0,
    'active' => 0,
    'inactive' => 0,
    'discount' => 0,
);

if (isset($licenses['status']) && $licenses['status'] == 'success') {
    $license_list = $licenses['data'] ?? array();
    $stats['total'] = count($license_list);
    foreach ($license_list as $license) {
        if (isset($license['status']) && $license['status'] == 1) {
            $stats['active']++;
        } else {
            $stats['inactive']++;
        }
    }
}

$discount_licenses = $api->getDiscountLicenses();
if (isset($discount_licenses['status']) && $discount_licenses['status'] == 'success') {
    $stats['discount'] = count($discount_licenses['data'] ?? array());
}

$balance = $api->getBalance();
$balance_amount = 0;
if (isset($balance['status']) && $balance['status'] == 'success') {
    $balance_amount = floatval($balance['data'] ?? 0);
}

?>
<div class="wrap licenzer-dashboard">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <div class="licenzer-stats">
        <div class="stat-box">
            <div class="stat-icon stat-primary">
                <span class="dashicons dashicons-admin-network"></span>
            </div>
            <div class="stat-content">
                <h3><?php echo esc_html($stats['total']); ?></h3>
                <p><?php _e('Total Licenses', 'licenzer'); ?></p>
            </div>
        </div>

        <div class="stat-box">
            <div class="stat-icon stat-success">
                <span class="dashicons dashicons-yes-alt"></span>
            </div>
            <div class="stat-content">
                <h3><?php echo esc_html($stats['active']); ?></h3>
                <p><?php _e('Active Licenses', 'licenzer'); ?></p>
            </div>
        </div>

        <div class="stat-box">
            <div class="stat-icon stat-warning">
                <span class="dashicons dashicons-tag"></span>
            </div>
            <div class="stat-content">
                <h3><?php echo esc_html($stats['discount']); ?></h3>
                <p><?php _e('Discount Licenses', 'licenzer'); ?></p>
            </div>
        </div>

        <div class="stat-box">
            <div class="stat-icon stat-info">
                <span class="dashicons dashicons-money-alt"></span>
            </div>
            <div class="stat-content">
                <h3>$<?php echo number_format($balance_amount, 2); ?></h3>
                <p><?php _e('Reseller Balance', 'licenzer'); ?></p>
            </div>
        </div>
    </div>

    <div class="licenzer-quick-actions">
        <h2><?php _e('Quick Actions', 'licenzer'); ?></h2>
        <a href="<?php echo admin_url('admin.php?page=licenzer-licenses'); ?>" class="button button-primary">
            <?php _e('View All Licenses', 'licenzer'); ?>
        </a>
        <a href="<?php echo admin_url('admin.php?page=licenzer-discount'); ?>" class="button button-secondary">
            <?php _e('Manage Discount Licenses', 'licenzer'); ?>
        </a>
        <a href="<?php echo admin_url('admin.php?page=licenzer-settings'); ?>" class="button button-secondary">
            <?php _e('Settings', 'licenzer'); ?>
        </a>
    </div>

    <?php
    // Show recent licenses
    if (isset($licenses['status']) && $licenses['status'] == 'success' && !empty($license_list)) {
        $recent = array_slice($license_list, 0, 10);
        ?>
        <div class="licenzer-recent">
            <h2><?php _e('Recent Licenses', 'licenzer'); ?></h2>
            <table class="wp-list-table widefat fixed striped">
                <thead>
                    <tr>
                        <th><?php _e('License Key', 'licenzer'); ?></th>
                        <th><?php _e('IP Address', 'licenzer'); ?></th>
                        <th><?php _e('Software', 'licenzer'); ?></th>
                        <th><?php _e('Status', 'licenzer'); ?></th>
                        <th><?php _e('Expiry Date', 'licenzer'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($recent as $license): ?>
                    <tr>
                        <td><code><?php echo esc_html($license['license_key'] ?? 'N/A'); ?></code></td>
                        <td><?php echo esc_html($license['ip'] ?? 'N/A'); ?></td>
                        <td><?php echo esc_html($license['software_name'] ?? $license['key'] ?? 'N/A'); ?></td>
                        <td>
                            <span class="status-badge status-<?php echo ($license['status'] ?? 0) ? 'active' : 'inactive'; ?>">
                                <?php echo ($license['status'] ?? 0) ? __('Active', 'licenzer') : __('Inactive', 'licenzer'); ?>
                            </span>
                        </td>
                        <td><?php echo esc_html($license['end_at'] ?? $license['Expired date'] ?? 'N/A'); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
        <?php
    }
    ?>
</div>

