<?php
/**
 * LicenZer Admin Dashboard Template
 */

require_once __DIR__ . '/../helper.php';

$api = new LicenZerAPIHelper($apiUrl, $resellerToken);

// Get statistics
$stats = $api->getStatistics();

?>

<div class="licenzer-admin-dashboard">
    <div class="page-header">
        <h2>LicenZer License Manager</h2>
        <p>Manage all your LicenZer licenses from this centralized dashboard</p>
    </div>
    
    <div class="row">
        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-icon bg-primary">
                    <i class="fas fa-key"></i>
                </div>
                <div class="stat-content">
                    <h3><?php echo $stats['total_licenses'] ?? 0; ?></h3>
                    <p>Total Licenses</p>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-icon bg-success">
                    <i class="fas fa-check-circle"></i>
                </div>
                <div class="stat-content">
                    <h3><?php echo $stats['active_licenses'] ?? 0; ?></h3>
                    <p>Active Licenses</p>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-icon bg-warning">
                    <i class="fas fa-tags"></i>
                </div>
                <div class="stat-content">
                    <h3><?php echo $stats['discount_licenses'] ?? 0; ?></h3>
                    <p>Discount Licenses</p>
                </div>
            </div>
        </div>
        
        <div class="col-md-3">
            <div class="stat-box">
                <div class="stat-icon bg-info">
                    <i class="fas fa-dollar-sign"></i>
                </div>
                <div class="stat-content">
                    <h3>$<?php echo number_format($stats['balance'] ?? 0, 2); ?></h3>
                    <p>Reseller Balance</p>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Quick Actions</h3>
                </div>
                <div class="panel-body">
                    <a href="<?php echo $modulelink; ?>&action=licenses" class="btn btn-primary">
                        <i class="fas fa-list"></i> View All Licenses
                    </a>
                    <a href="<?php echo $modulelink; ?>&action=discount" class="btn btn-success">
                        <i class="fas fa-tags"></i> Manage Discount Licenses
                    </a>
                    <a href="<?php echo $modulelink; ?>&action=settings" class="btn btn-info">
                        <i class="fas fa-cog"></i> Settings
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <div class="row mt-4">
        <div class="col-md-12">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <h3 class="panel-title">Recent Licenses</h3>
                </div>
                <div class="panel-body">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>License Key</th>
                                <th>IP Address</th>
                                <th>Software</th>
                                <th>Status</th>
                                <th>Expiry Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $recentLicenses = $api->getRecentLicenses(10);
                            foreach ($recentLicenses as $license) {
                                echo '<tr>';
                                echo '<td><code>' . htmlspecialchars($license['license_key']) . '</code></td>';
                                echo '<td>' . htmlspecialchars($license['ip']) . '</td>';
                                echo '<td>' . htmlspecialchars($license['software_name']) . '</td>';
                                echo '<td><span class="label label-' . ($license['status'] ? 'success' : 'danger') . '">' . ($license['status'] ? 'Active' : 'Inactive') . '</span></td>';
                                echo '<td>' . htmlspecialchars($license['end_at']) . '</td>';
                                echo '<td>';
                                echo '<a href="' . $modulelink . '&action=view&license_key=' . urlencode($license['license_key']) . '" class="btn btn-sm btn-info">View</a>';
                                echo '</td>';
                                echo '</tr>';
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>


