<?php
/**
 * Customer Licenses Model
 */
class ModelAccountLicenzer extends Model {
    
    /**
     * Get customer licenses
     */
    public function getCustomerLicenses($customerId) {
        $query = $this->db->query("SELECT * FROM " . DB_PREFIX . "licenzer_licenses WHERE customer_id = '" . (int)$customerId . "' ORDER BY created DESC");
        return $query->rows;
    }

    /**
     * Change IP
     */
    public function changeIp($licenseKey, $newIp, $customerId) {
        // Get license info
        $license = $this->db->query("SELECT * FROM " . DB_PREFIX . "licenzer_licenses WHERE license_key = '" . $this->db->escape($licenseKey) . "' AND customer_id = '" . (int)$customerId . "'")->row;

        if (!$license) {
            return array('status' => 'error', 'message' => 'License not found');
        }

        // Check IP change limit
        $maxChanges = (int)$this->config->get('module_licenzer_max_ip_changes');
        if ($maxChanges > 0 && $license['ip_changes'] >= $maxChanges) {
            return array('status' => 'error', 'message' => 'Maximum IP changes limit reached');
        }

        // Call API
        require_once(DIR_SYSTEM . 'library/licenzer_api.php');
        $apiUrl = $this->config->get('module_licenzer_api_url') ?: 'https://licenzer.pro';
        $token = $this->config->get('module_licenzer_reseller_token') ?: '';
        $api = new LicenzerApi($apiUrl, $token);

        $result = $api->changeIp($license['ip_address'], $newIp, $license['software_key']);

        if (isset($result['status']) && $result['status'] == 'success') {
            // Update database
            $this->db->query("UPDATE " . DB_PREFIX . "licenzer_licenses SET ip_address = '" . $this->db->escape($newIp) . "', ip_changes = ip_changes + 1 WHERE license_key = '" . $this->db->escape($licenseKey) . "'");
        }

        return $result;
    }
}

