<?php
/**
 * LicenZer Model
 */
class ModelExtensionModuleLicenzer extends Model {
    
    /**
     * Get API helper
     */
    private function getApi() {
        require_once(DIR_SYSTEM . 'library/licenzer_api.php');
        $apiUrl = $this->config->get('module_licenzer_api_url') ?: 'https://licenzer.pro';
        $token = $this->config->get('module_licenzer_reseller_token') ?: '';
        return new LicenzerApi($apiUrl, $token);
    }

    /**
     * Get statistics
     */
    public function getStatistics() {
        $api = $this->getApi();
        $licenses = $api->getLicenses();
        
        $stats = array(
            'total' => 0,
            'active' => 0,
            'inactive' => 0,
            'discount' => 0,
            'balance' => 0,
        );

        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            $license_list = $licenses['data'] ?? array();
            $stats['total'] = count($license_list);
            
            foreach ($license_list as $license) {
                if (isset($license['status']) && $license['status'] == 1) {
                    $stats['active']++;
                } else {
                    $stats['inactive']++;
                }
            }
        }

        $discount_licenses = $api->getDiscountLicenses();
        if (isset($discount_licenses['status']) && $discount_licenses['status'] == 'success') {
            $stats['discount'] = count($discount_licenses['data'] ?? array());
        }

        $balance = $api->getBalance();
        if (isset($balance['status']) && $balance['status'] == 'success') {
            $stats['balance'] = floatval($balance['data'] ?? 0);
        }

        return $stats;
    }

    /**
     * Get recent licenses
     */
    public function getRecentLicenses($limit = 10) {
        $api = $this->getApi();
        $licenses = $api->getLicenses();
        
        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            $license_list = $licenses['data'] ?? array();
            return array_slice($license_list, 0, $limit);
        }

        return array();
    }

    /**
     * Get all licenses
     */
    public function getLicenses() {
        $api = $this->getApi();
        $licenses = $api->getLicenses();
        
        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            return $licenses['data'] ?? array();
        }

        return array();
    }

    /**
     * Get discount licenses
     */
    public function getDiscountLicenses() {
        $api = $this->getApi();
        $licenses = $api->getDiscountLicenses();
        
        if (isset($licenses['status']) && $licenses['status'] == 'success') {
            return $licenses['data'] ?? array();
        }

        return array();
    }

    /**
     * Change IP
     */
    public function changeIp($currentIp, $newIp, $softwareKey) {
        $api = $this->getApi();
        return $api->changeIp($currentIp, $newIp, $softwareKey);
    }
}

