@extends('licenzer::layouts.admin')

@section('title', 'All Licenses')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <h1>All Licenses</h1>
        </div>
    </div>

    @if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
    @endif

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>License Key</th>
                                    <th>IP Address</th>
                                    <th>Software</th>
                                    <th>Status</th>
                                    <th>Expiry Date</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($licenseList as $license)
                                <tr>
                                    <td><code>{{ $license['license_key'] ?? 'N/A' }}</code></td>
                                    <td>{{ $license['ip'] ?? 'N/A' }}</td>
                                    <td>{{ $license['software_name'] ?? $license['key'] ?? 'N/A' }}</td>
                                    <td>
                                        @if($license['status'] ?? 0)
                                            <span class="badge bg-success">Active</span>
                                        @else
                                            <span class="badge bg-danger">Inactive</span>
                                        @endif
                                    </td>
                                    <td>{{ $license['end_at'] ?? $license['Expired date'] ?? 'N/A' }}</td>
                                    <td>
                                        <button type="button" class="btn btn-warning btn-sm change-ip-btn"
                                                data-license-key="{{ $license['license_key'] ?? '' }}"
                                                data-current-ip="{{ $license['ip'] ?? '' }}"
                                                data-software-key="{{ $license['key'] ?? '' }}">
                                            <i class="fas fa-exchange-alt"></i> Change IP
                                        </button>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">No licenses found</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Change IP Modal -->
<div class="modal fade" id="changeIpModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="{{ route('licenzer.admin.licenses.changeIp') }}" method="POST">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">Change IP Address</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <input type="hidden" name="license_key" id="modal-license-key">
                    <input type="hidden" name="software_key" id="modal-software-key">
                    <input type="hidden" name="current_ip" id="modal-current-ip">
                    
                    <div class="mb-3">
                        <label class="form-label">Current IP</label>
                        <input type="text" id="modal-current-ip-display" class="form-control" readonly>
                    </div>
                    <div class="mb-3">
                        <label for="new-ip" class="form-label">New IP Address</label>
                        <input type="text" name="new_ip" id="new-ip" class="form-control" required pattern="^([0-9]{1,3}\.){3}[0-9]{1,3}$" placeholder="192.168.1.1">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Change IP</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const changeIpButtons = document.querySelectorAll('.change-ip-btn');
    const modal = new bootstrap.Modal(document.getElementById('changeIpModal'));

    changeIpButtons.forEach(button => {
        button.addEventListener('click', function() {
            document.getElementById('modal-license-key').value = this.dataset.licenseKey;
            document.getElementById('modal-current-ip').value = this.dataset.currentIp;
            document.getElementById('modal-current-ip-display').value = this.dataset.currentIp;
            document.getElementById('modal-software-key').value = this.dataset.softwareKey;
            modal.show();
        });
    });
});
</script>
@endsection

