<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\Database\DatabaseInterface;

/**
 * LicenZer component helper.
 */
class LicenzerHelper
{
    /**
     * Get user licenses
     */
    public static function getUserLicenses($userId = null)
    {
        if (!$userId) {
            $user = Factory::getUser();
            $userId = $user->id;
        }

        if (!$userId) {
            return array();
        }

        $db = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->getQuery(true)
            ->select('*')
            ->from($db->quoteName('#__licenzer_licenses'))
            ->where($db->quoteName('user_id') . ' = ' . (int) $userId)
            ->order($db->quoteName('created') . ' DESC');

        $db->setQuery($query);
        return $db->loadObjectList();
    }
}

