<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Toolbar\ToolbarHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Router\Route;

HTMLHelper::_('behavior.formvalidator');
HTMLHelper::_('behavior.keepalive');

$app = Factory::getApplication();
$user = Factory::getUser();

$model = $this->getModel();
$discountLicenses = $model->getDiscountLicenses();

ToolbarHelper::title(Text::_('COM_LICENZER_SUBMENU_DISCOUNT'), 'tag');
ToolbarHelper::preferences('com_licenzer');

LicenzerHelper::addSubmenu('discount');
?>

<div class="row-fluid">
    <div id="j-main-container" class="span10">
        <div class="licenzer-discount">
            <div class="alert alert-info">
                <strong><?php echo Text::_('COM_LICENZER_DISCOUNT_INFO_TITLE'); ?></strong>
                <?php echo Text::_('COM_LICENZER_DISCOUNT_INFO_DESC'); ?>
            </div>

            <?php if (empty($discountLicenses)): ?>
                <div class="alert alert-warning">
                    <?php echo Text::_('COM_LICENZER_NO_DISCOUNT_LICENSES'); ?>
                </div>
            <?php else: ?>
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th><?php echo Text::_('COM_LICENZER_LICENSE_KEY'); ?></th>
                            <th><?php echo Text::_('COM_LICENZER_SOFTWARE'); ?></th>
                            <th><?php echo Text::_('COM_LICENZER_IP_ADDRESS'); ?></th>
                            <th><?php echo Text::_('COM_LICENZER_ORIGINAL_PRICE'); ?></th>
                            <th><?php echo Text::_('COM_LICENZER_DISCOUNT_PRICE'); ?></th>
                            <th><?php echo Text::_('COM_LICENZER_EXPIRY_DATE'); ?></th>
                            <th><?php echo Text::_('COM_LICENZER_ACTIONS'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($discountLicenses as $license): ?>
                        <tr>
                            <td><code><?php echo htmlspecialchars($license['license_key'] ?? 'N/A'); ?></code></td>
                            <td><?php echo htmlspecialchars($license['software_name'] ?? 'N/A'); ?></td>
                            <td><?php echo htmlspecialchars($license['ip'] ?? 'N/A'); ?></td>
                            <td><del>$<?php echo number_format($license['original_price'] ?? 0, 2); ?></del></td>
                            <td><strong style="color: #46b450;">$<?php echo number_format($license['price'] ?? 0, 2); ?></strong></td>
                            <td><?php echo htmlspecialchars($license['expiry_date'] ?? 'N/A'); ?></td>
                            <td>
                                <button class="btn btn-small assign-license-btn" 
                                        data-license-key="<?php echo htmlspecialchars($license['license_key'] ?? ''); ?>"
                                        data-ip="<?php echo htmlspecialchars($license['ip'] ?? ''); ?>">
                                    <?php echo Text::_('COM_LICENZER_ASSIGN_TO_USER'); ?>
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
    <div id="sidebar" class="span2">
        <?php echo HTMLHelper::_('sidebar.render'); ?>
    </div>
</div>

