<?php
/**
 * @package     LicenZer
 * @subpackage  com_licenzer
 *
 * @copyright   Copyright (C) 2024 LicenZer. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;

/**
 * LicenZer component helper.
 */
class LicenzerHelper
{
    /**
     * Configure the Linkbar.
     *
     * @param   string  $vName  The name of the active view.
     *
     * @return  void
     */
    public static function addSubmenu($vName)
    {
        HTMLHelper::_('sidebar.addEntry',
            Text::_('COM_LICENZER_SUBMENU_DASHBOARD'),
            'index.php?option=com_licenzer&view=dashboard',
            $vName == 'dashboard'
        );

        HTMLHelper::_('sidebar.addEntry',
            Text::_('COM_LICENZER_SUBMENU_LICENSES'),
            'index.php?option=com_licenzer&view=licenses',
            $vName == 'licenses'
        );

        HTMLHelper::_('sidebar.addEntry',
            Text::_('COM_LICENZER_SUBMENU_DISCOUNT'),
            'index.php?option=com_licenzer&view=discount',
            $vName == 'discount'
        );

        HTMLHelper::_('sidebar.addEntry',
            Text::_('COM_LICENZER_SUBMENU_SETTINGS'),
            'index.php?option=com_licenzer&view=settings',
            $vName == 'settings'
        );
    }

    /**
     * Gets a list of the actions that can be performed.
     *
     * @return  CMSObject
     */
    public static function getActions()
    {
        $user   = Factory::getUser();
        $result = new CMSObject;

        $actions = array(
            'core.admin',
            'core.manage',
            'core.create',
            'core.edit',
            'core.edit.own',
            'core.edit.state',
            'core.delete'
        );

        foreach ($actions as $action)
        {
            $result->set($action, $user->authorise($action, 'com_licenzer'));
        }

        return $result;
    }
}

